/*Getting started.. Function-Tables

A function table (usually called f-table) is a space for number storage. It can hold a list of numbers.  (1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1)
Which numbers, depends on the user's choice. You can enter them manualy, load data from an audio-file in the harddisk (jep, this also just contains numbers) or choose a GEN Routine to compute numbers of a waveform. So f-tables are often used as a waveform-buffer.

GEN routines are computer functions which automatically fill f-tables. There are different types of GEN routines for different functions. Some generate waveforms, some are good for envelopes, others create windowing functions, and other can read files from disk. You can see the available GEN routines in the CsoundQt Help Menu in the GEN Routines option.

The numbers contained in f-tables are used by many opcodes to get the information about the waveform they will play. The shape of the waveform has a huge influence on the sound's frequency spectrum. 
(A sound without overtones is generated by the 'sine waveform'. The 'sawtooth waveform' in comparison, has many overtones.)

An f-table can be created using the f-statement (or Function Table Statement) in the <CsScore> section. It creates the f-table and loads a GEN subroutine to fill values in the F-Table.

;f p1 p2 p3    p4  p5
 f 1  0  1024  10  1

p1 - gives the table a number (in this case 1)
p2 - says, at which time the table becomes filled, time in seconds (0 = immediately, when started)
p3 - sets the size of the table, which must be a power of 2 (1024 = 2**10) maxsize is 2**24
p4 - the number of the GEN ROUTINE (GEN 10 fills the table with a sine curve)
p5++ - individual settings needed by some GEN ROUTINES with more arguments

F-tables, filled with values from predefined functions like GEN 10 above, contain one cycle of the desired waveform.

see: (ScoreGenRef SHIFT+F1),(f SHIFT+F1)
*/
 
<CsoundSynthesizer>
<CsOptions>
-m0
</CsOptions>
<CsInstruments>


sr = 44100
ksmps = 32
nchnls = 2
0dbfs = 1

instr 1
aEnv madsr 0.1, 0.1, 1, 0.3
aWavetablePlayer oscili p4, cpspch(p5), p6
outs aWavetablePlayer*aEnv, aWavetablePlayer*aEnv
endin

</CsInstruments>

<CsScore>
f 1 0 1024 10 1 			  			; simple sinus waveform
f 2 0 1024 10 1 1 1 1 1 1 1 1 			; sinus with 7 partials -> (Additive Synthesis)
f 3 0 1024  9 1 3 0 3 1 0 9 0.3333 180 		; approx of square waveform ->see Help GEN09

; The r score statement repeats a section
r16 BOO
i 1 0.1 0.05 0.3 7.0 1 				; sinoid wavform
s

r8 BOO
i 1 0.1 0.05 0.3 7.0 2 				; same note but 7 partials
s

r8 BOO
i 1 0.1 0.05 0.3 7.0 3 				; same note with square waveform
s

r16 BOO
i 1 0.1 0.05 0.3 [6.0+0.01*$BOO] 1 
s

r4 BOO
i 1 0.1 0.05 0.3 6.0 2 
i 1 0.3 0.05 0.3 8.0 2 
s

r8 BOO
i 1 0.1 0.05 0.3 [7.09-0.01*$BOO] 3 
s

r8 BOO
i 1 0.0 0.05 0.3 [8.09-0.01*$BOO] 3 
s
r8 BOO
i 1 0.0 0.05 0.3 [7.09-0.01*$BOO] 3 
s

r1 BOO 
i 1 0.0 0.05 0.3 7.00 2 
i 1 0.1 0.05 0.3 10.00 1 
i 1 0.2 0.05 0.3 9.00 2 
i 1 0.3 0.05 0.3 8.00 3 
s

r1 BOO   
i 1 0.0 0.05 0.3 7.07 2 
i 1 0.1 0.05 0.3 9.07 1 
i 1 0.2 0.05 0.3 9.07 2 
i 1 0.3 0.05 0.3 8.07 3 
s

r4 BOO
i 1 0.0 0.05 0.3 10.00 1 
i 1 0.1 0.05 0.3 10.00 2 
i 1 0.2 0.05 0.3 8.00 3 
i 1 0.3 0.05 0.3 8.00 2 
s

r4 BOO
t 0 60   
i 1 0.1 0.05 0.3 8.00 1 
i 1 0.2 0.05 0.3 8.00 2 
i 1 0.3 0.05 0.3 8.00 3 
i 1 0.6 0.05 0.3 8.00 2 
s
e
</CsScore>
</CsoundSynthesizer>
/* 
(The F-Table size as a "power of 2" is not that limited anymore. By using a negativ operator in front of p3, you can choose freely (like -1023), but  this can cause problems with some opcodes.)
*/
; written by Alex Hofmann (Mar. 2010) - Incontri HMT-Hannover 

<bsbPanel>
 <label>Widgets</label>
 <objectName/>
 <x>1013</x>
 <y>279</y>
 <width>563</width>
 <height>397</height>
 <visible>true</visible>
 <uuid/>
 <bgcolor mode="background">
  <r>255</r>
  <g>255</g>
  <b>255</b>
 </bgcolor>
 <bsbObject version="2" type="BSBGraph">
  <objectName/>
  <x>7</x>
  <y>61</y>
  <width>253</width>
  <height>115</height>
  <uuid>{2b94b9d8-9c17-4f6c-84f3-ceed3cb1f77f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <value>0</value>
  <objectName2/>
  <zoomx>1.00000000</zoomx>
  <zoomy>1.00000000</zoomy>
  <dispx>1.00000000</dispx>
  <dispy>1.00000000</dispy>
  <modex>auto</modex>
  <modey>auto</modey>
  <all>true</all>
 </bsbObject>
 <bsbObject version="2" type="BSBScope">
  <objectName/>
  <x>6</x>
  <y>223</y>
  <width>258</width>
  <height>153</height>
  <uuid>{95ae72b5-8d91-48ee-9b31-9a558fa60d6e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <value>-255.00000000</value>
  <type>scope</type>
  <zoomx>2.00000000</zoomx>
  <zoomy>1.00000000</zoomy>
  <dispx>1.00000000</dispx>
  <dispy>1.00000000</dispy>
  <mode>0.00000000</mode>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>6</x>
  <y>5</y>
  <width>254</width>
  <height>53</height>
  <uuid>{aff020c4-672c-4c00-8937-59ec577b32c5}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>In this graph, one can see the result of the  generated F-Table values.</label>
  <alignment>left</alignment>
  <font>Lucida Grande</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>7</x>
  <y>193</y>
  <width>256</width>
  <height>26</height>
  <uuid>{8edf0582-7277-4f42-8228-0ba867eea2ca}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>The output-waveform..</label>
  <alignment>left</alignment>
  <font>Lucida Grande</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
</bsbPanel>
<bsbPresets>
</bsbPresets>
<EventPanel name="" tempo="60.00000000" loop="8.00000000" x="320" y="218" width="596" height="322" visible="true" loopStart="0" loopEnd="0">    </EventPanel>
